<?php

namespace Inside\TV\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Content\Events\ContentFullyInsertedEvent;
use Inside\Content\Events\ContentFullyUpdatedEvent;
use Inside\TV\Services\TVStatusService;

class TVContentsAlteredListener implements ShouldQueue
{
    public function handle(ContentFullyInsertedEvent|ContentFullyUpdatedEvent $event): void
    {
        $model = $event->model;

        if (in_array($model->getContentTypeAttribute(), config('tv.modules'))) {
            TVStatusService::requestingRefresh(
                (string) $model->tvScreens->first()->screen_id
            );
        }
    }
}
