<?php

namespace Inside\TV\Http\Middlewares;

use Closure;
use Illuminate\Http\Request;
use Inside\TV\Actions\CreateTvScreen;
use Inside\TV\Actions\DeleteTvScreen;

/**
 * Handle automatic translation
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class TvScreenMiddleware
{
    public function handle(Request $request, Closure $next): mixed
    {
        return match (true) {
            preg_match('/api\/v1\/content\/tv_screens$/i', $request->path()) &&
                $request->isMethod('POST') => (new CreateTvScreen($request, $next))->handle(),

            preg_match('/api\/v1\/content\/tv_screens\/(-?[0-9A-F]{4,12}){5}$/i', $request->path()) &&
                $request->isMethod('DELETE') => (new DeleteTvScreen($request, $next))->handle(),

            default => $next($request),
        };
    }
}
