<?php

namespace Inside\TV\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Lang;
use Inside\TV\Http\Requests\CreateTokenRequest;
use Inside\TV\Services\TvTokenService;
use Laravel\Lumen\Routing\Controller;

final class TokenController extends Controller
{
    public function __construct(private TvTokenService $tvTokenService)
    {
    }

    public function list(): JsonResponse
    {
        $tvScreen = request()->get('tv_screen');
        return response()->json(
            $this->tvTokenService->getAll($tvScreen)
        );
    }

    public function get(int $id): JsonResponse
    {
        return response()->json(
            $this->tvTokenService->get($id)
        );
    }

    public function create(CreateTokenRequest $request): JsonResponse
    {
        $data = $request->validated();
        $token = $this->tvTokenService->create($data);
        $status = 200;
        $response = [
            'token' => $token
        ];
        if (!$token) {
            $status = 400;
            $response =  [
                'error' => Lang::get('validation.tv.token.already.exists')
            ];
        }

        return response()->json($response, $status);
    }

    public function delete(int $id): JsonResponse
    {
        return response()->json(
            $this->tvTokenService->delete($id)
        );
    }
}
