<?php

namespace Inside\TV\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Support\Str;
use Inside\TV\Services\TVStatusService;
use Laravel\Lumen\Routing\Controller;

class RegisterUserController extends Controller
{
    public function __invoke(): JsonResponse
    {
        return response()->json([
            'status' => $this->isUuidRegistered()
        ]);
    }

    private function isUuidRegistered(): bool
    {
        $uuid = request()->get('uuid');
        $tvScreenId = request()->get('tvScreenId');

        if (Str::isUuid($uuid) && !empty($tvScreenId)) {
            return TVStatusService::registerUuid($uuid, $tvScreenId);
        }
        return false;
    }
}
