<?php

namespace Inside\TV\Http\Controllers;

use Illuminate\Http\JsonResponse;

use Inside\TV\Http\Requests\CreateIpRequest;
use Inside\TV\Services\TvIpService;
use Laravel\Lumen\Routing\Controller;

class IpController extends Controller
{
    public function __construct(private TvIpService $tvIpService)
    {
    }

    public function list(): JsonResponse
    {
        return response()->json(
            $this->tvIpService->getAll()
        );
    }

    public function get(int $id): JsonResponse
    {
        return response()->json(
            $this->tvIpService->get($id)
        );
    }

    public function create(CreateIpRequest $request): JsonResponse
    {
        $data = $request->validated();

        return response()->json([
            'id' => $this->tvIpService->create($data)
        ]);
    }

    public function delete(int $id): JsonResponse
    {
        return response()->json(
            $this->tvIpService->delete($id)
        );
    }
}
