<?php

namespace Inside\TV\Actions;

use Closure;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Inside\TV\Jobs\DeleteScreenTvSlidesJob;

final class DeleteTvScreen
{
    public function __construct(
        protected Request $request,
        private Closure $next
    ) {
    }

    public function handle(): JsonResponse
    {
        $response = $this->next($this->request);
        $data = $response->getData(true);
        if (
            !empty($data['uuid'])
        ) {
            DeleteScreenTvSlidesJob::dispatch($data['uuid']);
        }

        return $response;
    }


    private function next(Request $request): mixed
    {
        return ($this->next)($request);
    }
}
