<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'tv_videos',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => false,
        'categorizable' => false,
        'listing_type' => 'hidden',
        'title' => [
            'fr' => 'Vidéo TV',
            'en' => 'Video TV',
            'es' => 'Video TV',
            'de' => 'Video TV',
            'nl' => 'Video TV',
            'pt' => 'Video TV',
        ],
    ],
    'fields' => [
        [
            'name' => 'tv_screens',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => true,
            'searchable_filter' => true,
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Écran de TV',
                'en' => 'TV screen',
                'es' => 'Pantalla de TV',
                'de' => 'Fernsehbildschirm',
                'pt' => 'Tela de TV',
                'nl' => 'TV-scherm',
            ],
            'description' => [
                'fr' => 'Choix de la TV dans laquelle cet écran doit remonter',
                'en' => 'Choice of the TV in which this screen should appear',
                'es' => 'Elección de la TV en la que debe aparecer esta pantalla',
                'de' => 'Auswahl des Fernsehers, in dem dieser Bildschirm erscheinen soll',
                'pt' => 'Escolha da TV na qual esta tela deve aparecer',
                'nl' => 'Keuze van de tv waarop dit scherm moet verschijnen',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['tv_screens'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'weight',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Ordre d\'affichage',
                'en' => 'Display Order',
                'de' => 'Anzeigereihenfolge',
                'es' => 'Orden de visualización',
                'nl' => 'Weergavevolgorde',
                'pt' => 'Ordem de Exibição',
            ],
            'description' => [
                'fr' => 'Le chiffre le plus bas remonte en 1er',
                'en' => 'The lower number rises first',
                'de' => 'Die niedrigere Zahl steigt zuerst',
                'es' => 'El número más bajo sube primero',
                'nl' => 'Het lagere nummer stijgt eerst',
                'pt' => 'O número mais baixo sobe primeiro',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::INTEGER_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => 0,
        ],
        [
            'name' => 'video',
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 1,
            'title' => [
                'fr' => 'Vidéo',
                'en' => 'Video',
                'de' => 'Video',
                'es' => 'Video',
                'nl' => 'Video',
                'pt' => 'Video',
            ],
            'description' => [
                'fr' => 'La vidéo sera jouée entièrement avant passage à l\'écran suivant',
                'en' => 'The video will be played entirely before moving to the next screen',
                'de' => 'Das Video wird vollständig abgespielt, bevor zum nächsten Bildschirm gewechselt wird',
                'nl' => 'De video wordt volledig afgespeeld voordat naar het volgende scherm wordt gegaan',
                'pt' => 'O vídeo será reproduzido inteiramente antes de passar para a próxima tela',
                'es' => 'El video se reproducirá completamente antes de pasar a la siguiente pantalla'
            ],
            'widget' => [
                'type' => BridgeContentType::FILE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::FILE_FIELD,
            'settings' => [
                'display_field' => false,
                'display_default' => false,
                'uri_scheme' => 'public',
                'target_type' => 'file',
                'cardinality' => 1,
            ],
        ],
    ],

];
