<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'tv_movements',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => false,
        'categorizable' => false,
        'listing_type' => 'hidden',
        'title' => [
            'fr' => 'Mouvement TV',
            'en' => 'Movement TV',
            'es' => 'Movimiento TV',
            'de' => 'Bewegung TV',
            'nl' => 'Beweging TV',
            'pt' => 'Movimento TV'
        ],
    ],
    'fields' => [
        [
            'name' => 'weight',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Ordre d\'affichage',
                'en' => 'Display Order',
                'de' => 'Anzeigereihenfolge',
                'es' => 'Orden de visualización',
                'nl' => 'Weergavevolgorde',
                'pt' => 'Ordem de Exibição',
            ],
            'description' => [
                'fr' => 'Le chiffre le plus bas remonte en 1er',
                'en' => 'The lower number rises first',
                'de' => 'Die niedrigere Zahl steigt zuerst',
                'es' => 'El número más bajo sube primero',
                'nl' => 'Het lagere nummer stijgt eerst',
                'pt' => 'O número mais baixo sobe primeiro',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::INTEGER_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => 0,
        ],
        [
            'name' => 'movement_target',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 1,
            'title' => [
                'fr' => 'Choix du mouvement',
                'en' => 'Select the movement',
                'de' => 'Auswahl der Bewegung',
                'es' => 'Selección del movimiento',
                'nl' => 'Bewegingskeuze',
                'pt' => 'Escolha do movimento',
            ],
            'widget' => [
                'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['movements'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'image',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => true,
            'search_filter' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Image TV',
                'en' => 'Image TV',
                'de' => 'TV-Bild',
                'es' => 'Imagen de TV',
                'nl' => 'TV-afbeelding',
                'pt' => 'Imagem de TV',
            ],
            'description' => [
                'fr' => 'Ajoutez une image de présentation dédiée à la télévision. Si vous ne complétez pas ce champ, ou le champ couleur, la couleur secondaire sera utilisée en arrière-plan',
                'en' => 'Add a dedicated TV presentation image. If you do not complete this field, or the color field, the secondary color will be used in the background',
                'de' => 'Fügen Sie ein Bild für die Bewegung hinzu, das dem Fernsehen gewidmet ist. Wenn Sie dieses Feld nicht ausfüllen oder das Farbfeld nicht ausfüllen, wird die sekundäre Farbe als Hintergrund verwendet.',
                'es' => 'Agrega una imagen para el movimiento dedicada a la televisión. Si no completas este campo o el campo de color, se utilizará el color secundario como fondo',
                'nl' => 'Voeg een afbeelding toe voor de beweging die aan televisie is gewijd. Als u dit veld niet invult of het kleurveld niet invult, wordt de secundaire kleur als achtergrond gebruikt',
                'pt' => 'Adicione uma imagem para o movimento dedicada à televisão. Se não preencher este campo ou o campo de cor, a cor secundária será usada como plano de fundo',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 2,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'max_resolution' => '1920x1080',
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'color',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 3,
            'title' => [
                'fr' => "En cas d’absence d’image, choix de la couleur de fond",
                'en' => "If no image, choose background color",
                'de' => "Bei fehlendem Bild Hintergrundfarbe wählen",
                'nl' => "Bij afwezigheid van afbeelding, kies achtergrondkleur",
                'pt' => "Em caso de ausência de imagem, escolha a cor de fundo",
                'es' => "En caso de ausencia de imagen, elige el color de fondo"
            ],
            'description' => [
                'fr' => "Ajoutez une couleur de fond dédiée à la télévision. Si vous ne complétez pas ce champ, ou le champ image, la couleur secondaire sera utilisée en arrière-plan. Si une image est complétée la couleur ne sera pas affichée",
                'en' => 'If no color is selected, the secondary color of the website will be used in background',
                'es' => 'Agrega un color de fondo para la televisión. Si no completas este campo o el campo de imagen, se utilizará el color secundario como fondo. Si se completa una imagen, el color no se mostrará.',
                'de' => 'Fügen Sie eine Hintergrundfarbe für das Fernsehen hinzu. Wenn Sie dieses Feld nicht ausfüllen oder das Bildfeld nicht ausfüllen, wird die sekundäre Farbe als Hintergrund verwendet. Wenn ein Bild ausgefüllt ist, wird die Farbe nicht angezeigt',
                'pt' => 'Adicione uma cor de fundo para a televisão. Se não preencher este campo ou o campo de imagem, a cor secundária será usada como plano de fundo. Se uma imagem for preenchida, a cor não será exibida.',
                'nl' => 'Voeg een achtergrondkleur toe voor de televisie. Als u dit veld niet invult of het afbeeldingsveld niet invult, wordt de secundaire kleur als achtergrond gebruikt. Als een afbeelding is ingevuld, wordt de kleur niet weergegeven.',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_COLOR_PICKER_WIDGET,
                'settings' => [],
                'weight' => 3,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
    ],
];
