<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'tv_events',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => true,
        'aliasable' => true,
        'permissible' => false,
        'categorizable' => false,
        'listing_type' => 'hidden',
        'title' => [
            'fr' => 'Événement TV',
            'en' => 'Event TV',
            'es' => 'Evento TV',
            'de' => 'Ereignis TV',
            'nl' => 'Gebeurtenis TV',
            'pt' => 'Evento TV'
        ],
    ],
    'fields' => [
        [
            'name' => 'weight',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 6,
            'title' => [
                'fr' => 'Ordre d\'affichage',
                'en' => 'Display Order',
                'de' => 'Anzeigereihenfolge',
                'es' => 'Orden de visualización',
                'nl' => 'Weergavevolgorde',
                'pt' => 'Ordem de Exibição',
            ],
            'description' => [
                'fr' => 'Le chiffre le plus bas remonte en 1er',
                'en' => 'The lower number rises first',
                'de' => 'Die niedrigere Zahl steigt zuerst',
                'es' => 'El número más bajo sube primero',
                'nl' => 'Het lagere nummer stijgt eerst',
                'pt' => 'O número mais baixo sobe primeiro',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
                'weight' => 6,
            ],
            'type' => BridgeContentType::INTEGER_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => 0,
        ],
        [
            'name' => 'event_target',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Choix de l\'événement ',
                'en' => 'Event selection',
                'de' => 'Veranstaltungsauswahl',
                'es' => 'Selección de evento',
                'nl' => 'Evenementselectie',
                'pt' => 'Seleção de evento',
            ],
            'widget' => [
                'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['events'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'image',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => true,
            'search_filter' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => "Remplacer l’image de l'événement",
                'en' => "Replace event image",
                'de' => "Veranstaltungsbild ersetzen",
                'nl' => "Afbeelding van evenement vervangen",
                'pt' => "Substituir imagem do evento",
                'es' => "Reemplazar la imagen del evento"
            ],
            'description' => [
                'fr' => 'Ajoutez une image de présentation de l\'événement dédiée à la télévision. Si vous ne complétez pas ce champ, l\'image de prévisualisation de l\'événement sera utilisée en arrière-plan. Format recommandé : 1920x1080px',
                'en' => 'Add an image for the event dedicated to television. If you don\'t fill in this field, the event preview image will be used as the background',
                'de' => 'Fügen Sie ein Bild für die der Veranstaltung gewidmete Fernsehsendung hinzu. Wenn Sie dieses Feld nicht ausfüllen, wird das Vorschaubild der Veranstaltung als Hintergrund verwendet',
                'es' => 'Agrega una imagen para el evento dedicada a la televisión. Si no completas este campo, se utilizará la imagen de vista previa del evento como fondo',
                'nl' => 'Voeg een afbeelding toe voor het evenement dat aan televisie is gewijd. Als u dit veld niet invult, wordt de voorbeeldafbeelding van het evenement als achtergrond gebruikt',
                'pt' => 'Adicione uma imagem para o evento dedicada à televisão. Se não preencher este campo, a imagem de visualização do evento será usada como plano de fundo',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'max_resolution' => '1920x1080',
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'color',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => "En cas d’absence d’image, choix de la couleur de fond",
                'en' => "If no image, choose background color",
                'de' => "Bei fehlendem Bild Hintergrundfarbe wählen",
                'nl' => "Bij afwezigheid van afbeelding, kies achtergrondkleur",
                'pt' => "Em caso de ausência de imagem, escolha a cor de fundo",
                'es' => "En caso de ausencia de imagen, elige el color de fondo"
            ],
            'description' => [
                'fr' => "Ajoutez une couleur de fond dédiée à la télévision. Si vous ne complétez pas ce champ, ou le champ image, la couleur secondaire sera utilisée en arrière-plan. Si une image est complétée la couleur ne sera pas affichée",
                'en' => 'If no color is selected, the secondary color of the website will be used in background',
                'es' => 'Agrega un color de fondo para la televisión. Si no completas este campo o el campo de imagen, se utilizará el color secundario como fondo. Si se completa una imagen, el color no se mostrará.',
                'de' => 'Fügen Sie eine Hintergrundfarbe für das Fernsehen hinzu. Wenn Sie dieses Feld nicht ausfüllen oder das Bildfeld nicht ausfüllen, wird die sekundäre Farbe als Hintergrund verwendet. Wenn ein Bild ausgefüllt ist, wird die Farbe nicht angezeigt',
                'pt' => 'Adicione uma cor de fundo para a televisão. Se não preencher este campo ou o campo de imagem, a cor secundária será usada como plano de fundo. Se uma imagem for preenchida, a cor não será exibida.',
                'nl' => 'Voeg een achtergrondkleur toe voor de televisie. Als u dit veld niet invult of het afbeeldingsveld niet invult, wordt de secundaire kleur als achtergrond gebruikt. Als een afbeelding is ingevuld, wordt de kleur niet weergegeven.',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_COLOR_PICKER_WIDGET,
                'settings' => [],
                'weight' => 2,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
    ],
];
