<?php

use Illuminate\Support\Facades\Route;
use Inside\TV\Http\Controllers\TokenController;

Route::group(
    [
        'namespace' => 'Inside\TV\Http\Controllers',
        'prefix' => 'api/v1/tv',
        'middleware' => ['auth.api'],
    ],
    function ($router) {
        $router->get('weather/{uuid}', ['uses' => 'WeatherController@getWeather']);
        $router->get('is-reload-needed', ['uses' => 'ReloadTvController']);
        $router->get('register-user-uuid', ['uses' => 'RegisterUserController']);

        $router->get('tv_token', ['uses' => 'TokenController@list']);
        $router->get('tv_token/{id}', ['uses' => 'TokenController@get']);
        $router->post('tv_token', ['uses' => 'TokenController@create']);
        $router->delete('tv_token/{id}', ['uses' => 'TokenController@delete']);

        $router->get('tv_ip', ['uses' => 'IpController@list']);
        $router->get('tv_ip/{id}', ['uses' => 'IpController@get']);
        $router->post('tv_ip', ['uses' => 'IpController@create']);
        $router->delete('tv_ip/{id}', ['uses' => 'IpController@delete']);
    }
);

Route::group(
    [
        'namespace' => 'Inside\TV\Http\Controllers',
        'prefix' => 'api/v1',
    ],
    function ($router) {
        $router->post('tv', ['uses' => 'TvController@loginAsTv']);
    }
);
