<?php

namespace Inside\TV\Providers;

use Inside\Content\Events\ContentFullyInsertedEvent;
use Inside\Content\Events\ContentFullyUpdatedEvent;
use Inside\Content\Events\ContentSavedEvent;
use Inside\Support\EventServiceProvider;
use Inside\TV\Console\InstallCommand;
use Inside\TV\Http\Middlewares\TvScreenMiddleware;
use Inside\TV\Http\Middlewares\UserTvRequest;
use Inside\TV\Listeners\TVContentsAlteredListener;
use Inside\TV\Listeners\TVScreenAlteredListener;
use Inside\TV\Listeners\TVSettingsAlteredListener;
use Inside\TV\Services\OpenWeatherMapService;

/**
 * Inside Twitter service.
 *
 * @category Class
 * @package  Inside\TV\Providers
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class TVServiceProvider extends EventServiceProvider
{
    protected array $commands = [
        InstallCommand::class
    ];

    protected array $listen = [
        ContentFullyInsertedEvent::class => [
            TVContentsAlteredListener::class
        ],
        ContentFullyUpdatedEvent::class => [
            TVContentsAlteredListener::class
        ],
        ContentSavedEvent::class => [
            TVScreenAlteredListener::class
        ]
    ];

    /**
     * Register the application services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->singleton(OpenWeatherMapService::class, function () {
            return new OpenWeatherMapService(env('OPENWEATHERMAP_API_KEY') ?? '');
        });

        if ($this->app->runningInConsole()) {
            $this->app->singleton(
                'command.inside.tv,install',
                function () {
                    return new InstallCommand();
                }
            );
            $this->commands('command.inside.tv,install');
        }

        $this->mergeConfigFrom(__DIR__.'/../../config/tv.php', 'tv');
        $this->mergeConfigTo(__DIR__.'/../../config/permission.php', 'permission');
        $this->mergeConfigTo(__DIR__.'/../../config/archive.php', 'archive');

        $this->app->middleware([
            TvScreenMiddleware::class,
        ]);
    }
}
