<?php

namespace Inside\TV\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Inside\Jobs\Bus\Dispatchable;
use Inside\TV\Services\DuplicateScreenTvService;

class DuplicateScreenTvJob implements ShouldQueue
{
    use Queueable;
    use InteractsWithQueue;
    use Dispatchable;

    public function __construct(
        private string $parentUuid,
        private string $uuid
    ) {
    }

    public function handle(DuplicateScreenTvService $duplicateScreenTvService): void
    {
        $duplicateScreenTvService->duplicate(
            $this->parentUuid,
            $this->uuid
        );
    }
}
