<?php

namespace Inside\TV\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Inside\Jobs\Bus\Dispatchable;
use Inside\TV\Services\DeleteScreenTvSlidesService;

class DeleteScreenTvSlidesJob implements ShouldQueue
{
    use Queueable;
    use InteractsWithQueue;
    use Dispatchable;

    public function __construct(
        private string $tvScrennUuid
    ) {
    }

    public function handle(DeleteScreenTvSlidesService $deleteScreenTvSlidesService): void
    {
        $deleteScreenTvSlidesService->delete(
            $this->tvScrennUuid
        );
    }
}
