<?php

namespace Inside\TV\Http\Requests;

use Illuminate\Support\Facades\Lang;
use Inside\Http\Requests\FormRequest;

class CreateTokenRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'title' => 'required|string',
            'tv_screen_uuid' => 'required|string',
        ];
    }

    public function messages(): array
    {
        return [
            'title.required' => Lang::get('validation.title.required'),
            'title.string' => Lang::get('validation.title.string'),
            'tv_screen_uuid.required' => Lang::get('validation.tv_screen_uuid.required'),
            'tv_screen_uuid.string' => Lang::get('validation.tv_screen_uuid.string'),
        ];
    }
}
