<?php

namespace Inside\TV\Http\Requests;

use Illuminate\Support\Facades\Lang;
use Illuminate\Validation\ValidationException;
use Inside\Content\Validation\Rules\IpOrRangeRule;
use Inside\Http\Requests\FormRequest;
use Inside\TV\Models\TvIp;

class CreateIpRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'ip' => [
                'required',
                'string',
                new IpOrRangeRule(),
            ],
            'title' => 'required|string',
        ];
    }

    public function messages(): array
    {
        return [
            'ip.required' => Lang::get('validation.ip.required'),
            'ip.string' => Lang::get('validation.ip.string'),
            'title.required' => Lang::get('validation.title.required'),
            'title.string' => Lang::get('validation.title.string'),
        ];
    }

    protected function prepareForValidation(): void
    {
        if (TvIp::where('ip', $this->input('ip'))->exists()) {
            throw ValidationException::withMessages([
                'ip' => [
                    Lang::get('validation.ip.unique'),
                ],
            ]);
        }
    }
}
