<?php

namespace Inside\TV\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Inside\Content\Models\Contents\TvWeathers;
use Inside\TV\Services\OpenWeatherMapService;
use Laravel\Lumen\Routing\Controller;

class WeatherController extends Controller
{
    protected string $apiKey;

    public function __construct(private OpenWeatherMapService $openWeatherMapService)
    {
    }

    public function getWeather(string $uuid): JsonResponse
    {
        $tvWeather = TvWeathers::find($uuid);
        return $this->openWeatherMapService
            ->setCity((string)$tvWeather->city)
            ->setCountry((string)$tvWeather->country)
            ->getWeather();
    }
}
