<?php

namespace Inside\TV\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Support\Str;
use Inside\TV\Services\TVStatusService;
use Laravel\Lumen\Routing\Controller;

class ReloadTvController extends Controller
{
    public function __invoke(): JsonResponse
    {
        $reload = false;
        $uuid = request()->get('uuid');
        $tvScreenId = request()->get('tvScreenId');

        if (
            Str::isUuid($uuid) &&
            !empty($tvScreenId) &&
            ($reload = TVStatusService::isRefreshNeeded($uuid))
        ) {
            TVStatusService::clearStatus($uuid, $tvScreenId);
        }
        return response()->json(compact('reload'));
    }
}
