<?php

namespace Inside\TV\Actions;

use Closure;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Inside\Host\Bridge\BridgeContent;
use Inside\LHG\Jobs\UpdateContentThroughJob;
use Inside\LHG\Services\DuplicateLogicService;
use Inside\TV\Jobs\DuplicateScreenTvJob;
use Inside\TV\Services\DuplicateScreenTvService;
use Inside\Validation\ValidateRequests;

final class CreateTvScreen
{
    private string $parentUuid = '';

    public function __construct(
        protected Request $request,
        private Closure $next
    ) {
    }

    public function handle(): JsonResponse
    {
        if ($this->request->has('uuid')) {
            $this->parentUuid = $this->request->get('uuid');
        }

        $response = $this->next($this->request);
        $data = $response->getData(true);

        if (!empty($this->parentUuid) && !empty($data['uuid'])) {
            DuplicateScreenTvJob::dispatch($this->parentUuid, $data['uuid']);
        }

        return $response;
    }


    private function next(Request $request): mixed
    {
        return ($this->next)($request);
    }
}
