<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;
use Inside\Content\Facades\Schema as InsideSchema;

class AddTvScreenToTvContents extends Migration
{
    use CreateContentTypes;

    private BridgeContent $bridgeContent;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->migrateContent('tv_screens', false);
        $this->call('models:rebuild');
        $this->finishUp();

        $tvScreenExists = type_to_class('tv_screens')::all()->isNotEmpty();
        $this->bridgeContent = new BridgeContent();

        if ($tvScreenExists) {
            return;
        }

        /**
         * @var string $tvScreenUuid
         */
        $tvScreenUuid = $this->bridgeContent->contentInsert(
            type: 'tv_screens',
            data: [
                'title' => 'TV',
                'screen_duration' => 8
            ],
            creation: true,
            fromCli: true
        );

        collect([
            'tv_cards',
            'tv_datetime',
            'tv_events',
            'tv_movements',
            'tv_news',
            'tv_videos',
            'tv_weathers'
        ])->each(fn ($type) => $this->addTvScreenToContents($type, $tvScreenUuid));
    }

    private function addTvScreenToContents(string $type, string $tvScreenUuid): void
    {
        if (! InsideSchema::hasModel($type)) {
            return;
        }
        $this->bootUp(__FILE__);
        $this->migrateContent($type, false);
        $this->call('models:rebuild');
        $this->finishUp();

        type_to_class($type)::all()->each(
            fn ($content) => $this->bridgeContent->contentUpdate(
                type: $type,
                data: [
                    'uuid' => $content->uuid,
                    'uuid_host' => $content->uuid_host,
                    'tv_screens' => $tvScreenUuid
                ]
            )
        );
    }
}
