<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Authentication\Models\User;
use Inside\Host\Bridge\BridgeContent;

class DefaultRgpdTvAccount extends Migration
{
    public function up(): void
    {
        $user = User::where('email', config('tv.email_tv'))->first();
        if ($user && !$user->is_gdpr_compliant) {
            $bridge = new BridgeContent();
            $bridge->contentUpdate(
                type: 'users',
                data: [
                    'uuid' => $user->uuid,
                    'uuid_host' => $user->uuid_host,
                    'email' => config('tv.email_tv'),
                    'name' => config('tv.email_tv'),
                    'is_gdpr_compliant' => true,
                ],
                fromCli: true
            );
        }
    }
}
