<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;
use Inside\TV\Services\TVContentFilterService;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Content\Facades\Schema;

class CleanPermission extends Migration
{
    public function up(): void
    {
        $service = app(TVContentFilterService::class);

        $modules = collect(config('tv.modules', []));
        $validModules = $service->getValidContentTypes();

        $failedDependencies = collect(config('tv.module_dependencies', []))
            ->filter(fn ($dependencies, $module) => !$validModules->contains($module))
            ->keys();

        $insideFailedModules = $failedDependencies->map(fn ($module) => str_replace('tv_', '', $module));

        $insideFailedModules->each(
            fn ($module) =>
        DB::table('inside_permissions_schema')
            ->where('authorizable_type', 'LIKE', "%$module%")
            ->delete()
        );
        $bridge = new BridgeContentType();

        $failedDependencies->each(function ($module) use ($bridge) {
            if (Schema::hasContentType($module)) {
                $bridge->contentTypeDelete($module);
            }
        });
    }
}
