<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'tv_screens',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => true,
        'permissible' => false,
        'categorizable' => true,
        'listing_type' => 'hidden',
        'title' => [
            'fr' => 'Écran de TV',
            'en' => 'TV screen',
            'es' => 'Pantalla de TV',
            'de' => 'Fernsehbildschirm',
            'pt' => 'Tela de TV',
            'nl' => 'TV-scherm',
        ],
    ],
    'fields' => [
        [
            'name' => 'screen_duration',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 0,
            'title' => [
                'fr' => 'Durée d\'affichage d\'un écran',
                'en' => 'Screen display duration',
                'es' => 'Duración de visualización de una pantalla',
                'de' => 'Anzeigedauer eines Bildschirms',
                'pt' => 'Duração de exibição de uma tela',
                'nl' => 'Weergaveduur van een scherm',
            ],
            'description' => [
                'fr' => 'Nous recommandons 8 secondes par écran. Les vidéos seront jouées entièrement avant de passer à l\'écran suivant',
                'en' => 'We recommend 8 seconds per screen. Videos will play in full before moving to the next screen',
                'es' => 'Recomendamos 8 segundos por pantalla. Los videos se reproducirán completamente antes de pasar a la siguiente pantalla',
                'de' => 'Wir empfehlen 8 Sekunden pro Bildschirm. Videos werden vollständig abgespielt, bevor zum nächsten Bildschirm gewechselt wird',
                'pt' => 'Recomendamos 8 segundos por tela. Os vídeos serão reproduzidos completamente antes de passar para a próxima tela',
                'nl' => 'We raden 8 seconden per scherm aan. Video\'s worden volledig afgespeeld voordat naar het volgende scherm wordt overgegaan',

            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::INTEGER_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => 8,
        ],
        [
            'name' => 'screen_id',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'unique' => true,
            'weight' => 2,
            'title' => [
                'fr' => 'Id de l\'écran',
                'en' => 'Screen ID',
                'es' => 'ID de pantalla',
                'de' => 'Bildschirm-ID',
                'pt' => 'ID da tela',
                'nl' => 'Scherm-ID',
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [

                ],
                'weight' => 2,
                'hidden' => true,
            ],
            'type' => BridgeContentType::INTEGER_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => 1,
        ],
    ],
];
