<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'tv_news',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => false,
        'categorizable' => false,
        'listing_type' => 'hidden',
        'title' => [
            'fr' => 'Actualité TV',
            'en' => 'News TV',
            'es' => 'Noticias TV',
            'de' => 'Nachrichten TV',
            'nl' => 'Nieuws TV',
            'pt' => 'Notícias TV'
        ],
    ],
    'fields' => [
        [
            'name' => 'tv_screens',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => true,
            'searchable_filter' => true,
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Écran de TV',
                'en' => 'TV screen',
                'es' => 'Pantalla de TV',
                'de' => 'Fernsehbildschirm',
                'pt' => 'Tela de TV',
                'nl' => 'TV-scherm',
            ],
            'description' => [
                'fr' => 'Choix de la TV dans laquelle cet écran doit remonter',
                'en' => 'Choice of the TV in which this screen should appear',
                'es' => 'Elección de la TV en la que debe aparecer esta pantalla',
                'de' => 'Auswahl des Fernsehers, in dem dieser Bildschirm erscheinen soll',
                'pt' => 'Escolha da TV na qual esta tela deve aparecer',
                'nl' => 'Keuze van de tv waarop dit scherm moet verschijnen',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['tv_screens'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'weight',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Ordre d\'affichage',
                'en' => 'Display Order',
                'de' => 'Anzeigereihenfolge',
                'es' => 'Orden de visualización',
                'nl' => 'Weergavevolgorde',
                'pt' => 'Ordem de Exibição',
            ],
            'description' => [
                'fr' => 'Le chiffre le plus bas remonte en 1er',
                'en' => 'The lower number rises first',
                'de' => 'Die niedrigere Zahl steigt zuerst',
                'es' => 'El número más bajo sube primero',
                'nl' => 'Het lagere nummer stijgt eerst',
                'pt' => 'O número mais baixo sobe primeiro',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::INTEGER_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => 0,
        ],
        [
            'name' => 'news_target',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 1,
            'title' => [
                'fr' => 'Choix de l\'actualité à remonter',
                'en' => 'Choose the news to select',
                'de' => 'Auswahl der hochzuladenden Nachricht',
                'es' => 'Selección de la noticia a destacar',
                'nl' => 'Kies het nieuws om in de kijker te zetten',
                'pt' => 'Escolha da notícia a destacar',
            ],
            'widget' => [
                'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['news'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'image',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => true,
            'search_filter' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => "Remplacer l’image de l’article",
                'en' => "Replace article image",
                'de' => "Artikelbild ersetzen",
                'nl' => "Afbeelding van artikel vervangen",
                'pt' => "Substituir imagem do artigo",
                'es' => "Reemplazar la imagen del artículo"
            ],
            'description' => [
                'fr' => 'Ajoutez une image de présentation de l\'actualité dédiée à la télévision. Si vous ne complétez pas ce champ, l\'image de prévisualisation de l\'actualité sera utilisée en arrière-plan. Format recommandé : 1920x1080px',
                'en' => 'Add an image for the news dedicated to television. If you don\'t fill in this field, the news preview image will be used as the background',
                'de' => 'Fügen Sie ein Bild für die der Veranstaltung gewidmete Fernsehsendung hinzu. Wenn Sie dieses Feld nicht ausfüllen, wird das Vorschaubild der Veranstaltung als Hintergrund verwendet',
                'es' => 'Agrega una imagen para el evento dedicada a la televisión. Si no completas este campo, se utilizará la imagen de vista previa del evento como fondo',
                'nl' => 'Voeg een afbeelding toe voor het evenement dat aan televisie is gewijd. Als u dit veld niet invult, wordt de voorbeeldafbeelding van het evenement als achtergrond gebruikt',
                'pt' => 'Adicione uma imagem para o evento dedicada à televisão. Se não preencher este campo, a imagem de visualização do evento será usada como plano de fundo',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 2,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'max_resolution' => '1920x1080',
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'color',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 3,
            'title' => [
                'fr' => "En cas d’absence d’image, choix de la couleur de fond",
                'en' => "If no image, choose background color",
                'de' => "Bei fehlendem Bild Hintergrundfarbe wählen",
                'nl' => "Bij afwezigheid van afbeelding, kies achtergrondkleur",
                'pt' => "Em caso de ausência de imagem, escolha a cor de fundo",
                'es' => "En caso de ausencia de imagen, elige el color de fondo"
            ],
            'description' => [
                'fr' => "Ajoutez une couleur de fond dédiée à la télévision. Si vous ne complétez pas ce champ, ou le champ image, la couleur secondaire sera utilisée en arrière-plan. Si une image est complétée la couleur ne sera pas affichée",
                'en' => 'If no color is selected, the secondary color of the website will be used in background',
                'es' => 'Agrega un color de fondo para la televisión. Si no completas este campo o el campo de imagen, se utilizará el color secundario como fondo. Si se completa una imagen, el color no se mostrará.',
                'de' => 'Fügen Sie eine Hintergrundfarbe für das Fernsehen hinzu. Wenn Sie dieses Feld nicht ausfüllen oder das Bildfeld nicht ausfüllen, wird die sekundäre Farbe als Hintergrund verwendet. Wenn ein Bild ausgefüllt ist, wird die Farbe nicht angezeigt',
                'pt' => 'Adicione uma cor de fundo para a televisão. Se não preencher este campo ou o campo de imagem, a cor secundária será usada como plano de fundo. Se uma imagem for preenchida, a cor não será exibida.',
                'nl' => 'Voeg een achtergrondkleur toe voor de televisie. Als u dit veld niet invult of het afbeeldingsveld niet invult, wordt de secundaire kleur als achtergrond gebruikt. Als een afbeelding is ingevuld, wordt de kleur niet weergegeven.',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_COLOR_PICKER_WIDGET,
                'settings' => [],
                'weight' => 3,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'is_truncate_content',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'search_filter' => false,
            'required' => false,
            'weight' => 3,
            'title' => [
                'fr' => "Masquer le chapô de l'actualité",
                'en' => 'Hide the lead-in of the news',
                'de' => 'Den Nachrichtenaufmacher verbergen',
                'nl' => 'Introductie van het nieuws verbergen',
                'pt' => 'Ocultar a introdução da notícia',
                'es' => 'Ocultar la introducción de la noticia'
            ],
            'description' => [
                'fr' => 'En cochant cette case, seul le titre de l\'actualité sera remonté sur l\'écran et l\'introduction sera cachée',
                'en' => 'By checking this box, only the title of the news will be brought up on the screen and the introduction will be hidden',
                'de' => 'Durch Ankreuzen dieses Kästchens wird nur der Titel der Nachricht auf dem Bildschirm angezeigt, und die Einleitung wird versteckt',
                'es' => 'Al marcar esta casilla, solo se mostrará el título de la noticia en la pantalla y se ocultará la introducción',
                'nl' => 'Door dit vakje aan te vinken, wordt alleen de titel van het nieuws weergegeven op het scherm en wordt de inleiding verborgen',
                'pt' => 'Ao marcar esta caixa, apenas o título da notícia será exibido na tela, e a introdução será ocultada.',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 3,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => false,
        ],
    ],
];
