<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'tv_cards',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => false,
        'categorizable' => false,
        'listing_type' => 'hidden',
        'title' => [
            'fr' => 'Texte et image TV',
            'en' => 'Text and image TV',
            'es' => 'Texto e imagen TV',
            'de' => 'Text und Bild TV',
            'nl' => 'Tekst en afbeelding TV',
            'pt' => 'Texto e imagem TV'
        ],
    ],
    'fields' => [
        [
            'name' => 'weight',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Ordre d\'affichage',
                'en' => 'Display Order',
                'de' => 'Anzeigereihenfolge',
                'es' => 'Orden de visualización',
                'nl' => 'Weergavevolgorde',
                'pt' => 'Ordem de Exibição',
            ],
            'description' => [
                'fr' => 'Le chiffre le plus bas remonte en 1er',
                'en' => 'The lower number rises first',
                'de' => 'Die niedrigere Zahl steigt zuerst',
                'es' => 'El número más bajo sube primero',
                'nl' => 'Het lagere nummer stijgt eerst',
                'pt' => 'O número mais baixo sobe primeiro',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::INTEGER_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => 0,
        ],
        [
            'name' => 'introduction',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'search_filter' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Titre affiché sur l\'écran',
                'en' => 'Title displayed on screen',
                'de' => 'Titel wird auf dem Bildschirm angezeigt',
                'es' => 'Título mostrado en pantalla',
                'nl' => 'Titel weergegeven op het scherm',
                'pt' => 'Título exibido na tela',
            ],
            'widget' => [
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                    'rows' => 5,
                    'placeholder' => '',
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'settings' => [
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'card_introduction',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'search_filter' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Introduction',
                'en' => 'Introduction',
                'de' => 'Einführung',
                'es' => 'Introducción',
                'nl' => 'Inleiding',
                'pt' => 'Introdução',
            ],
            'widget' => [
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                    'rows' => 5,
                    'placeholder' => '',
                ],
                'weight' => 2,
            ],
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'settings' => [
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'image',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => true,
            'search_filter' => false,
            'required' => false,
            'weight' => 3,
            'title' => [
                'fr' => 'Image TV',
                'en' => 'Image TV',
                'de' => 'TV-Bild',
                'es' => 'Imagen de TV',
                'nl' => 'TV-afbeelding',
                'pt' => 'Imagem de TV',
            ],
            'description' => [
                'fr' => 'Ajoutez une image dédiée à la télévision. Si vous ne complétez pas ce champ, ou le champ image, la couleur secondaire sera utilisée en arrière-plan.',
                'en' => 'Add an image dedicated to television. If you do not complete this field, or the image field, the secondary color will be used in the background.',
                'de' => 'Fügen Sie ein dem Fernsehen gewidmetes Bild hinzu. Wenn Sie dieses Feld oder das Bildfeld nicht ausfüllen, wird die Sekundärfarbe im Hintergrund verwendet.',
                'es' => 'Agrega una imagen dedicada a la televisión. Si no completa este campo, o el campo de imagen, el color secundario se utilizará en el fondo.',
                'nl' => 'Voeg een afbeelding toe die gewijd is aan televisie. Als u dit veld of het afbeeldingsveld niet invult, wordt de secundaire kleur op de achtergrond gebruikt.',
                'pt' => 'Adicione uma imagem dedicada à televisão. Caso não preencha este campo, ou o campo da imagem, a cor secundária será utilizada no fundo.',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 3,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'max_resolution' => '1920x1080',
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'color',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 4,
            'title' => [
                'fr' => "En cas d’absence d’image, choix de la couleur de fond",
                'en' => "If no image, choose background color",
                'de' => "Bei fehlendem Bild Hintergrundfarbe wählen",
                'nl' => "Bij afwezigheid van afbeelding, kies achtergrondkleur",
                'pt' => "Em caso de ausência de imagem, escolha a cor de fundo",
                'es' => "En caso de ausencia de imagen, elige el color de fondo"

            ],
            'description' => [
                'fr' => "Ajoutez une couleur de fond dédiée à la télévision. Si vous ne complétez pas ce champ, ou le champ image, la couleur secondaire sera utilisée en arrière-plan. Si une image est complétée la couleur ne sera pas affichée.",
                'en' => 'Add a dedicated background color to the television. If you do not complete this field, or the image field, the secondary color will be used in the background. If an image is completed the color will not be displayed.',
                'es' => 'Agrega un color de fondo para la televisión. Si no completas este campo o el campo de imagen, se utilizará el color secundario como fondo. Si se completa una imagen, el color no se mostrará.',
                'de' => 'Fügen Sie dem Fernseher eine spezielle Hintergrundfarbe hinzu. Wenn Sie dieses Feld oder das Bildfeld nicht ausfüllen, wird die Sekundärfarbe im Hintergrund verwendet. Wenn ein Bild fertig ist, wird die Farbe nicht angezeigt.',
                'pt' => 'Adicione uma cor de fundo dedicada à televisão. Caso não preencha este campo, ou o campo da imagem, a cor secundária será utilizada no fundo. Se uma imagem for concluída, a cor não será exibida.',
                'nl' => 'Voeg een speciale achtergrondkleur toe aan de televisie. Als u dit veld of het afbeeldingsveld niet invult, wordt de secundaire kleur op de achtergrond gebruikt. Als een afbeelding voltooid is, wordt de kleur niet weergegeven.',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_COLOR_PICKER_WIDGET,
                'settings' => [],
                'weight' => 4,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
    ],
];
