<?php

use Illuminate\Support\Carbon;

if (!function_exists('inside_search_solr_get_type_from_solr_type')) {
    /**
     * Get an Inside type from a solr one
     *
     * @param string $name
     *
     * @return string|false
     */
    function inside_search_solr_get_type_from_solr_type(string $name)
    {
        if (preg_match("/^inside_(.+)_index$/", $name, $matches)) {
            return $matches[1];
        }

        return false;
    }
}

if (!function_exists('inside_search_solr_get_date_filter')) {
    /**
     * Get an Inside type from a solr one
     *
     * @param string $key
     * @param mixed $value
     *
     * @return array
     */
    function inside_search_solr_get_date_filter(string $key, mixed $value): array
    {
        [$field, $operator] = explode(':', $key);
        $field .= '_date';
        $value = ($value instanceof Carbon) ? $value : Carbon::parse($value);
        switch ($operator) {
            case 'lt':
            case 'lte':
                $value = '[* TO ' . $value->toISOString() . ']';
                break;
            case 'gt':
            case 'gte':
                $value = '[' . $value->toISOString() . ' TO *]';
                break;
        }

        return [$field , $value];
    }
}
