<?php

namespace Inside\Search\Solr\Providers;

use Illuminate\Support\ServiceProvider;
use Inside\Search\Solr\Engines\SolrEngine;
use Inside\Search\Solr\Facades\Solr;
use Laravel\Scout\EngineManager;

/**
 * Class ScoutServiceProvider
 *
 * @package Inside\Search\Solr\Providers
 */
class ScoutServiceProvider extends ServiceProvider
{
    /**
     * {@inheritDoc}
     */
    public function boot(): void
    {
        // Extend scout engine to solr
        app(EngineManager::class)->extend('solr', function () {
            return new SolrEngine();
        });
    }

    /**
     * {@inheritDoc}
     */
    public function register(): void
    {
        $this->app->alias('Solr', Solr::class);
    }
}
