<?php

namespace Inside\Search\Solr\Providers;

use Illuminate\Support\Facades\Event;
use Illuminate\Support\ServiceProvider;
use Inside\Search\Solr\Adapter\InsideCurl;
use Laravel\Scout\EngineManager;
use Solarium\Client as SolrClient;
use Symfony\Component\EventDispatcher\EventDispatcher;

/**
 * Inside package search Solr indexing service.
 *
 * @category Class
 * @package  Inside
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class InsideSearchSolrServiceProvider extends ServiceProvider
{
    /**
     *
     * @var array
     */
    protected $listen = [];

    /**
     * Bootstrap the application services.
     *
     * @return void
     */
    public function boot(): void
    {
        $this->app->config->set('scout.driver', 'solr');

        // Register event handlers
        foreach ($this->listens() as $event => $listeners) {
            foreach ($listeners as $listener) {
                Event::listen($event, $listener);
            }
        }
    }

    /**
     * Register the application services.
     *
     * @return void
     */
    public function register(): void
    {
        $this->mergeConfigFrom(
            __DIR__ . '/../../config/solr.php',
            'solr'
        );

        // Register solarium client as a singleton
        $this->app->singleton(SolrClient::class, function () {
            return new SolrClient(new InsideCurl(), new EventDispatcher(), ['endpoint' => config('solr.endpoints')]);
        });

        $this->app->singleton(EngineManager::class, function ($app) {
            return new EngineManager($app);
        });
    }

    /**
     * Get handlers
     *
     * @return array
     */
    public function listens(): array
    {
        return $this->listen;
    }

    /**
     *
     * @return array
     */
    public function provides()
    {
        return [SolrClient::class];
    }
}
