<?php

namespace Inside\Search\Solr\Models;

use Illuminate\Support\Collection;
use Laravel\Scout\Searchable;
use Inside\Search\Solr\Facades\Solr;

/**
 * Class Index
 *
 * Fake model to search in several models
 *
 * @package Inside\Search\Solr\Models
 */
class Index
{
    use Searchable;

    /**
     * Delete index
     */
    public static function truncate(): void
    {
        $update = Solr::createUpdate();

        $update->addDeleteQuery('*:*');
        $update->addCommit();

        Solr::update($update);
    }

    public function newCollection(array $models): Collection
    {
        return collect($models);
    }
}
