<?php

namespace Inside\Search\Solr\Http\Controllers;

use Illuminate\Support\Facades\Auth;
use Inside\Content\Models\Contents\Users;
use Inside\Search\Solr\Facades\Solr;
use Inside\Search\Solr\Models\Search;
use RuntimeException;

/**
 * SolR Controller
 *
 * @category Class
 * @package  Inside\Search\Solr\Http\Controllers\SearchSolrController
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class SearchSolrController
{
    /**
     * Ping solr server
     */
    public function ping(): void
    {
        try {
            $time = microtime(true);
            $mem  = memory_get_usage();

            $client = app(\Solarium\Client::class);

            $ping = $client->createPing();

            $result = $client->ping($ping);
            echo 'Ping query successful';
            echo '<br/><pre>';
            dump($result->getData());
            echo '</pre>';
            dump(
                [
                    'memory'        => (memory_get_usage() - $mem) / (1024 * 1024),
                    'ms'            => (microtime(true) - $time) * 1000,
                    'global_memory' => (memory_get_usage() - $GLOBALS['INSIDE_START_MEMORY']) / (1024 * 1024),
                    'global_ms'     => (microtime(true) - $GLOBALS['INSIDE_START_TIME']) * 1000,
                ]
            );
            echo "<br />";
        } catch (RuntimeException $e) {
            echo 'Ping query failed';
        }
    }

    public function testIndexation(): void
    {
        try {
            $time = microtime(true);
            $mem  = memory_get_usage();

            $user = Users::find(Auth::user()->uuid);

            echo 'Indexing user ( ' . $user->email . ' )';
            $datas = $user->toSearchableArray();
            dump($datas);

            $update = Solr::createUpdate();
            $update->addOptimize();

            $document = $update->createDocument($datas);
            $update->addDocument($document);

            $update->addCommit();

            try {
                $result = Solr::update($update);

                if ($result->getStatus() != 0) {
                    dump($result->getData());
                }
            } catch (\Exception $e) {
                dump($e);
            }

            dump(
                [
                    'memory'        => (memory_get_usage() - $mem) / (1024 * 1024),
                    'ms'            => (microtime(true) - $time) * 1000,
                    'global_memory' => (memory_get_usage() - $GLOBALS['INSIDE_START_MEMORY']) / (1024 * 1024),
                    'global_ms'     => (microtime(true) - $GLOBALS['INSIDE_START_TIME']) * 1000,
                ]
            );
            echo "<br />";
        } catch (RuntimeException $e) {
            echo 'Indexation query failed';
            dump($e);
        }
    }

    public function testMultipleIndexation(): void
    {
        try {
            $time = microtime(true);
            $mem  = memory_get_usage();

            $users = Users::take(20)->get();

            $update = Solr::createUpdate();

            $documents = [];
            echo 'Indexing 20 users';
            foreach ($users as $user) {
                $documents[] = $update->createDocument($user->toSearchableArray());
            }
            $update->addDocuments($documents);
            $update->addCommit();
            $update->addOptimize();

            try {
                $result = Solr::update($update);

                if ($result->getStatus() != 0) {
                    dump($result->getData());
                }
            } catch (\Exception $e) {
                dump($e);
            }

            dump(
                [
                    'memory'        => (memory_get_usage() - $mem) / (1024 * 1024),
                    'ms'            => (microtime(true) - $time) * 1000,
                    'global_memory' => (memory_get_usage() - $GLOBALS['INSIDE_START_MEMORY']) / (1024 * 1024),
                    'global_ms'     => (microtime(true) - $GLOBALS['INSIDE_START_TIME']) * 1000,
                ]
            );
            echo "<br />";
        } catch (RuntimeException $e) {
            echo 'Indexation query failed';
            dump($e);
        }
    }
}
