<?php

namespace Inside\Search\Database\Support;

use Doctrine\DBAL\Schema\Index;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class MysqlFullTextSupport extends FullTextSupport
{
    public static function listCurrentIndexes(string $table): array
    {
        return collect(Schema::getConnection()->getDoctrineSchemaManager()->listTableIndexes($table))
            ->filter(fn (Index $index) => is_int(strpos($index->getName(), $table)))
            ->keys()
            ->map(fn (string $index) => (string) str($index)->after($table.'_')->before('_index'))
            ->toArray();
    }

    public static function createIndex(string $table, string $name): bool
    {
        $index = "{$table}_{$name}";

        return DB::statement("CREATE FULLTEXT INDEX {$index} ON {$table} ({$name})");
    }

    public static function buildMatchQuery(string $column, string $search, int $rank): string
    {
        $query = "MATCH(`{$column}`) AGAINST(LOWER('{$search}') IN NATURAL LANGUAGE MODE)";

        return "(CASE WHEN {$query} > 1 THEN {$query} * {$rank} ELSE 0 END)";
    }

    public static function buildLikeQuery(string $column, string $search, int $rank): string
    {
        $query = "{$column} LIKE '{$search}'";

        return "(CASE WHEN {$query} THEN {$rank} ELSE 0 END)";
    }
}
