<?php

namespace Inside\Search\Database\Providers;

use Illuminate\Database\DatabaseManager;
use Illuminate\Support\Facades\Event;
use Inside\Search\Database\Contracts\FullText;
use Inside\Search\Database\Support\MysqlFullTextSupport;
use Inside\Search\Database\Support\PgsqlFullTextSupport;
use Inside\Support\EventServiceProvider;
use Inside\Search\Database\Console\IndexCommand;
use Inside\Search\Database\Services\IndexerService;
use Inside\Search\Database\Services\ModelService;
use Inside\Search\Database\Services\SearcherService;
use Inside\Search\Database\Console\SearchForceIndexCommand;
use Laravel\Scout\EngineManager;

/**
 * Search database service provider
 *
 * @category Class
 * @package  Inside\Search\Database\Providers\SearchDatabaseServiceProvider
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class SearchDatabaseServiceProvider extends EventServiceProvider
{
    public array $singletons = [
        EngineManager::class => EngineManager::class,
        ModelService::class => ModelService::class,
    ];
    public function register(): void
    {
        $this->mergeConfigFrom(__DIR__ . '/../../config/scout.php', 'scout');
        $this->mergeConfigFrom(__DIR__ . '/../../config/tika.php', 'tika');

        match (config('scout.driver')) {
            'pgsql' => $this->app->singleton(FullText::class, PgsqlFullTextSupport::class),
            default => $this->app->singleton(FullText::class, MysqlFullTextSupport::class),
        };

        $this->app->singleton(IndexerService::class, function ($app) {
            return new IndexerService($app->make(ModelService::class), $app->make(FullText::class));
        });

        $this->app->singleton(SearcherService::class, function ($app) {
            return new SearcherService($app->make(IndexerService::class), $app->make(DatabaseManager::class));
        });
    }

    /**
     * Get handlers
     *
     * @return array
     */
    public function listens(): array
    {
        return $this->listen;
    }
}
