<?php

namespace Inside\Search\Database\Models\Traits;

use Illuminate\Support\Str;
use Inside\Content\Models\Field;
use Inside\Search\Database\Models\Index;
use Laravel\Scout\Searchable as ScoutSearchable;

/**
 * Trait Searchable
 *
 * @category Class
 * @package  Inside\Search\Database\Models\Traits\Searchable
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
trait Searchable
{
    use ScoutSearchable;

    /**
     * @return array
     */
    public function getSearchableColumns()
    {
        $fields = Field::whereHas(
            'model',
            function ($query) {
                $query->whereClass(get_class($this));
            }
        )->get();

        // Get searchable columns
        return $fields->filter(
            function ($field) {
                $options = $field->options;

                return (isset($options['searchable']) && $options['searchable']);
            }
        )->pluck('name');
    }

    /**
     * @return mixed
     */
    public function index()
    {
        return $this->morphOne(Index::class, 'indexable');
    }

    /**
     *
     * @return string
     */
    public function searchableAs()
    {
        $index = str_replace('\\', '', Str::snake(Str::plural(class_basename($this))));

        return 'inside_' . $index . '_index';
    }
}
