<?php

namespace Inside\Search\Database\Models;

use Illuminate\Database\Eloquent\Model;
use Inside\Database\Eloquent\WithEnhancedBuilder;
use Laravel\Scout\Searchable;

/**
 * Index Model
 *
 * @category Class
 * @package  Inside\Search\Database\Models\Index
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class Index extends Model
{
    // Scout searchable, we don't want to index the index table ...
    use Searchable;
    use WithEnhancedBuilder;

    protected $table = 'inside_search_database_indexes';

    protected $fillable = [
        'langcode',
        'indexable_type',
        'indexable_id',
        'important_content',
        'filter',
        'content',
        'published',
        'title',
        'created_at',
        'updated_at',
        'published_at',
    ];

    protected $dates = [
        'published_at',
    ];

    protected $casts = [
        'published' => 'boolean',
        'published_at' => 'timestamp',
    ];

    /**
     * Get the real object
     *
     * @return \Illuminate\Database\Eloquent\Relations\MorphTo
     */
    public function indexable()
    {
        return $this->morphTo();
    }
}
