<?php

namespace Inside\Search\Database\Contracts;

interface FullText
{
    public static function listCurrentIndexes(string $table): array;

    public static function hasIndex(string $table, string $name): bool;

    public static function createIndex(string $table, string $name): bool;

    public static function dropIndex(string $table, string $name): void;

    public static function dropIndexes(string $table, array $names): void;

    public static function buildMatchQuery(string $column, string $search, int $rank): string;

    public static function buildLikeQuery(string $column, string $search, int $rank): string;
}
