<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\Artisan;

/**
 * Class AlterInsideSearchDatabaseIndexesAddFilterColumnTable
 *
 */
class AddPublishedAtColumnToSearchIndex extends Migration
{
    public function up(): void
    {
        Schema::table(
            'inside_search_database_indexes',
            function (Blueprint $table) {
                $table->timestamp('published_at')->index()->nullable();
            }
        );
        Artisan::call('index:rebuild');
    }

    public function down(): void
    {
        Schema::table(
            'inside_search_database_indexes',
            function (Blueprint $table) {
                $table->dropColumn('published_at');
            }
        );
    }
}
