<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\Artisan;

/**
 * Class AlterInsideSearchDatabaseIndexesAddFilterColumnTable
 *
 */
class AddColumnsOnIndexes extends Migration
{
    public function up(): void
    {
        Schema::table(
            'inside_search_database_indexes',
            function (Blueprint $table) {
                $table->string('title', 1000)->index();
                $table->boolean('published')->index()->default(false);
                $table->timestamp('created_at')->index()->nullable();
                $table->timestamp('updated_at')->index()->nullable();
            }
        );
        Artisan::call('index:rebuild');
    }

    public function down(): void
    {
        Schema::table(
            'inside_search_database_indexes',
            function (Blueprint $table) {
                $table->dropColumn('title');
                $table->dropColumn('published');
                $table->dropColumn('created_at');
                $table->dropColumn('updated_at');
            }
        );
    }
}
