<?php

namespace Inside\Search\Database\Support;

use Doctrine\DBAL\Schema\Index;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Inside\Search\Database\Contracts\FullText;

abstract class FullTextSupport implements FullText
{
    abstract public static function listCurrentIndexes(string $table): array;

    abstract public static function createIndex(string $table, string $name): bool;

    public static function hasIndex(string $table, string $name): bool
    {
        return in_array($name, static::listCurrentIndexes($table));
    }

    public static function dropIndex(string $table, string $name): void
    {
        Schema::table($table, fn (Blueprint $table) => $table->dropIndex($name));
    }

    public static function dropIndexes(string $table, array $names): void
    {
        $existing = array_intersect(static::listCurrentIndexes($table), $names);

        foreach ($existing as $name) {
            static::dropIndex($table, $name);
        }
    }
}
