<?php

namespace Inside\Search\Database\Services;

use Illuminate\Support\Facades\DB;
use Inside\Content\Models\Content;

/**
 * Our model service
 *
 * @category Class
 * @package  Inside\Search\Database\Services\ModelService
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ModelService
{
    /**
     * @var string
     */
    public $model;

    /**
     * @var string
     */
    public $connectionName;

    /**
     * @var string
     */
    public $tablePrefix;

    /**
     * @var string
     */
    public $tableName;

    /**
     * @var string
     */
    public $tablePrefixedName;

    /**
     * @var string
     */
    public $indexName;

    /**
     * @param string $model
     *
     * @return $this
     */
    public function setModel(string $model): ModelService
    {
        /** @var Content $modelInstance */
        $modelInstance           = new $model();
        $this->model             = $model;
        $this->connectionName    = $modelInstance->getConnectionName() ?? config('database.default');
        $this->tablePrefix       = config("database.connections.$this->connectionName.prefix", '');
        $this->tableName         = $modelInstance->getTable();
        $this->tablePrefixedName = $this->tablePrefix . $this->tableName;
        $this->indexName         = $modelInstance->searchableAs();

        return $this;
    }


    /**
     * @return array
     */
    public function getFullTextIndexFields(): array
    {
        return [ 'content' => [ 'content' ] , 'important_content' => ['important_content']];
    }
}
