<?php

namespace Inside\Search\Database\Providers;

use Illuminate\Support\ServiceProvider;
use Inside\Search\Database\Engines\DatabaseEngine;
use Laravel\Scout\EngineManager;

/**
 * Scout service provider
 *
 * @category Class
 * @package  Inside\Search\Database\Providers\ScoutServiceProvider
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ScoutServiceProvider extends ServiceProvider
{
    /**
     *
     */
    public function boot(): void
    {
        // Extend scout engine to solr
        app(EngineManager::class)->extend('mysql', function () {
            return new DatabaseEngine();
        });

        app(EngineManager::class)->extend('pgsql', function () {
            return new DatabaseEngine();
        });
    }

    public function register(): void
    {
        //
    }
}
