# Inside Search Database

| Method | Endpoint | Parameters | Return |
|---|---|---|---|
| GET | /api/v1/search | query=SEARCHED_STRING & filters=FILTERS & fields=FIELDS & page=PAGE & autocomplete=BOOLEAN &langcode=LANG| [{result},{result}] |

test

**The query parameter is required**

**The parameters**

The `query` is a string and is the keywords searched

The `page` is an int indicating which page is asked

The `langcode` is a char(2) indicating which lang is searched ( example : langcode=fr for searching french doc ). By default, if no langcode is provided, the search will be performed independently of language.

The autocomplete is an boolean indicating if search is for autocomplete of results. If true, the result will search in important column instead of content one. By default, result will be searched in content column.

The `filters` format is a JSON which describe the filters needed :

```json
{
  "in" : [
     "news",
     "events"
  ],
  "limit":10,
  "order":"content:asc"
}
```

The fields format is JSON which describe fields wanted :

```json
["title","body","uuid","url"]
```

If "in" is set, the search will only be on models ( News and Events in the example ), models must be valid

If no parameters is set, the search will be performed in all searchable models

We can get all Searchable model with Searchable Facade

Pagination is done with ```limit``` and ```page``` as parameter

Order is done with ```order```

** Searchable classes **

```php

use Inside\Search\Solr\Facades\Searchable;

$models = Searchable::getSearchableClasses();

```

A Searchable model is a Dynamic Model generated in inside-content that as
trait Searchable.

Each model is indexed on "inside-<type>-index"

** Pagination **

If limit is set and > 0, pagination is auto magically activated

Result is changing with this kind of format :

```json

{
  "current_page": 2,
  "data": {
      "news": [
            {
                  "uuid": "479706cf-9900-4156-bdb4-8300f38e9cb3",
                  "langcode": "en",
                  "author": "6e59d498-7fd6-4153-9568-817814697539",
                  "title": "test",
                  "created_at": 1531116556,
                  "updated_at": 1531116556,
                  "is_slideshow": 0,
                  "is_featured": 0,
                  "image": null,
                  "body": null,
                  "score": 0.098578475,
                  "link": "test-3"
            }
      ]
    },
  "first_page_url": "http://icfo.maecia/api/v1/search?query=test&filters=%7B%22limit%22%3A1%2C%22order%22%3A%22content%3Aasc%22%7D&page=1",
  "from": 2,
  "last_page": 5,
  "last_page_url": "http://icfo.maecia/api/v1/search?query=test&filters=%7B%22limit%22%3A1%2C%22order%22%3A%22content%3Aasc%22%7D&page=5",
  "next_page_url": "http://icfo.maecia/api/v1/search?query=test&filters=%7B%22limit%22%3A1%2C%22order%22%3A%22content%3Aasc%22%7D&page=3",
  "path": "http://icfo.maecia/api/v1/search",
  "per_page": 1,
  "prev_page_url": "http://icfo.maecia/api/v1/search?query=test&filters=%7B%22limit%22%3A1%2C%22order%22%3A%22content%3Aasc%22%7D&page=1",
  "to": 2,
  "total": 5
}

```

# Rebuilding indexes

You can rebuil all index database from models using this command

```bash
php artisan index:rebuild
```

Accepting --silent for no output


# Note on indexing file content

If a searchable column has a name finished by _file, we'll try to index file content by Tika. The content of column must contain
an existing file path.
