<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class RefactoFullsearchIndex extends Migration
{
    public function up(): void
    {
        Schema::table('inside_search_database_indexes', function (Blueprint $table) {
            $table->dropIndex('inside_search_database_indexes_content');
            $table->dropIndex('inside_search_database_indexes_important_content');
        });

        DB::statement('
            ALTER TABLE inside_search_database_indexes
            ADD FULLTEXT INDEX fulltext_combined_content (content, important_content)
        ');
    }

    public function down(): void
    {
        Schema::table('inside_search_database_indexes', function (Blueprint $table) {
            $table->dropIndex('fulltext_combined_content');
        });

        DB::statement('
            ALTER TABLE inside_search_database_indexes
            ADD FULLTEXT INDEX inside_search_database_indexes_content (content),
            ADD FULLTEXT INDEX inside_search_database_indexes_important_content (important_content)
        ');
    }
}
