<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

/**
 * Class AlterInsideSearchDatabaseIndexesTable
 *
 */
class AlterInsideSearchDatabaseIndexesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (Schema::hasTable('inside_search_database_indexes')) {
            // Should exists !
            Schema::table('inside_search_database_indexes', function (Blueprint $table) {
                $table->longText('important_content')->nullable()->after('content');
            });
        }
    }


    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasTable('inside_search_database_indexes')) {
            // Should exists !
            Schema::table('inside_search_database_indexes', function (Blueprint $table) {
                $table->dropColumn('important_content');
            });
        }
    }
}
