<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateInsideSearchDatabaseIndexesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('inside_search_database_indexes')) {
            Schema::create('inside_search_database_indexes', function (Blueprint $table) {
                $table->increments('id');
                $table->longText('content')->nullable();
                $table->string('indexable_type');
                $table->uuid('indexable_id');
                $table->char('langcode', 2)->nullable();
                $table->index(['indexable_id', 'indexable_type', 'langcode'], 'search_index');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('inside_search_database_indexes');
    }
}
