<?php

namespace Inside\RSS\Providers;

use Inside\Providers\ServiceProvider;

/**
 * Inside Rss service.
 *
 * @category Class
 * @package  Inside\RSS\Providers\RssServiceProvider
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class RssServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap the application services.
     *
     * @return void
     */
    public function boot()
    {
        $this->loadViewsFrom(__DIR__.'/../../resources/views', 'rss');
    }

    /**
     * Register the application services.
     *
     * @return void
     */
    public function register()
    {
        $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/feed.php', 'feed');
    }
}
