<?php

namespace Inside\Reservation\Notifications\Channels;

use Illuminate\Notifications\Channels\MailChannel as BaseMailChannel;
use Illuminate\Support\Str;

class MailChannel extends BaseMailChannel
{
    /**
     * @param $mailMessage
     * @param $message
     * @return void
     */
    protected function addAttachments($mailMessage, $message): void
    {
        $swiftMessage = $mailMessage->getSwiftMessage();

        foreach ($message->rawAttachments as $attachment) {
            if (Str::endsWith($attachment['name'], '.ics')) {
                $swiftMessage->setBody($attachment['data'], 'text/calendar; method=REQUEST');
                break;
            }
        }

        foreach ($message->attachments as $attachment) {
            $swiftMessage->attach($attachment['file']);
        }

        foreach ($message->rawAttachments as $attachment) {
            if (!Str::endsWith($attachment['name'], '.ics')) {
                $mailMessage->attachData($attachment['data'], $attachment['name'], $attachment['options']);
            }
        }
    }
}
