<?php

namespace Inside\Reservation\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Content\Events\ContentUpdatingEvent;
use Inside\Host\Bridge\BridgeContent;

class UpdateReservationsOnRoomUpdating implements ShouldQueue
{
    public function handle(ContentUpdatingEvent $event): void
    {
        $room = $event->model;
        $contentType = class_to_type($room);
        if ($contentType !== 'rooms' || ! $room->isDirty('default_cooldown')) {
            return;
        }

        $bridgeContent = new BridgeContent();
        $room->reverseRoomsReservations->each(fn ($reservation) => $bridgeContent->contentUpdate('rooms_reservations', [
            'uuid' => $reservation->uuid,
            'cooldown' => $room->default_cooldown,
        ]));
    }
}
