<?php

namespace Inside\Reservation\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Arr;
use Symfony\Component\HttpFoundation\Response;

class SetDefaultCooldownOnReservationForm
{
    /**
     * @param Request $request
     * @param Closure $next
     * @return mixed|Response
     */
    public function handle(Request $request, Closure $next)
    {
        $path = $request->path();
        $matches = null;
        $pattern = '#^api/v1/form/([^_]+)_reservations(/[\da-f]{8}-[\da-f]{4}-[\da-f]{4}-[\da-f]{4}-[\da-f]{12})?$#iD';

        if (
            $request->getMethod() == 'GET'
            && preg_match($pattern, $path, $matches) > 0
        ) {
            $type = $matches[1];
            $uuid = $matches[2] ? substr($matches[2], 1) : null;
            $response = $next($request);
            if ($response instanceof Response && $response->getStatusCode() != 200) {
                return $response;
            }

            $data = json_decode($response->getContent(), true);
            if (!is_array($data) || !array_key_exists('data', $data) || !is_array($data['data'])) {
                return $response;
            }
            $coolDownField = Arr::where(
                $data['data'],
                function ($value, $key) {
                    return array_key_exists('name', $value) && $value['name'] == 'cooldown';
                }
            );
            $coolDownKey = array_key_first($coolDownField);
            $coolDownField = Arr::first($coolDownField);
            if (!$uuid) {
                $uuid = $request->get('room_uuid');
            }
            $resource = call_user_func(type_to_class($type) . '::find', $uuid);
            if (!$resource || $resource->default_cooldown === null) {
                return $response;
            }
            $coolDownField['options']['default'] = $resource->default_cooldown;
            $data['data'][$coolDownKey] = $coolDownField;
            set_response($response, json_encode($data));

            return $response;
        }

        return $next($request);
    }
}
