<?php

namespace Inside\Reservation\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Validator;
use Inside\Reservation\Facades\Reservation;
use Inside\Reservation\Rules\Rrule;
use Psr\Http\Message\RequestInterface;

class ReservationValidation
{
    /**
     * @param Request $request
     * @param Closure $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        $path = $request->path();
        $matches = null;
        $pattern = '#^api/v1/content/([^_]+)_reservations(/[\da-f]{8}-[\da-f]{4}-[\da-f]{4}-[\da-f]{4}-[\da-f]{12})?$#iD';

        if (
            in_array($request->getMethod(), ['POST', 'PUT'])
            && preg_match($pattern, $path, $matches) > 0
        ) {
            $type = $matches[1];
            $uuid = array_key_exists(2, $matches) && $matches[2] ? substr($matches[2], 1) : null;
            Reservation::loadAvailableRule();
            Validator::make(
                $request->all(),
                [
                    $type => 'required|available' . ($uuid ? ":{$uuid}" : ''),
                    'start_date' => 'sometimes|required|date|before:end_date',
                    'end_date' => 'sometimes|required|date',
                    'frequency' => new Rrule(),
                ],
                [
                    'start_date.before' => Lang::get('validation.start_date.before'),
                    'end_date.after_or_equal' => Lang::get('validation.end_date.after_or_equal'),
                ]
            )->validate();
        }

        return $next($request);
    }
}
