<?php

namespace Inside\Reservation\Contracts;

use DateTimeZone;
use Illuminate\Support\Carbon;
use Illuminate\Validation\Validator as IlluminateValidator;
use Recurr\Rule;

interface Reservation
{
    public function getReservationList(
        array $types,
        int $startDate,
        int $endDate,
        array $filters = [],
        array $fields = []
    ): array;

    public function checkAvailabilityOnRecurse(
        Rule $rule,
        Carbon $startDate,
        Carbon $endDate,
        array $exceptions = []
    ): bool;

    public function shiftTimezone(Carbon $carbonDate, DateTimeZone|string $value): Carbon;

    public function addRealMicroseconds(Carbon $carbonDate, int $value): Carbon;

    public function loadAvailableRule(): void;

    public function checkAvailability(
        string $attribute,
        ?string $uuid,
        mixed $value,
        Carbon $startDate,
        Carbon $endDate,
        IlluminateValidator $validator
    ): bool;

    public function getLastConflictedReservation(): ?array;
}
