<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Lang;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Database\Migrations\HasConsole;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Support\Str;

class ChangeBodyFieldOnReservation extends Migration
{
    use HasConsole;

    public function up(): void
    {
        $bridge        = new BridgeContentType();
        $contentBridge = new BridgeContent();
        $this->writeln('Recherche des types de contenu de réservations');
        $this->separatorLine('yellow');
        $types = InsideSchema::getContentTypes(
            function ($model) {
                $type = class_to_type($model['class']);

                return Str::endsWith($type, '_reservations');
            }
        );
        foreach ($types as $type) {
            $fieldTitles = [];
            foreach (list_languages() as $locale) {
                $fieldTitles[$locale] = Lang::get('reservation.fields.reservation_description', [], $locale);
            }
            $fieldOptions = [
                'name'                => 'reservation_description',
                'searchable'          => false,
                'translatable'        => false,
                'default'             => '',
                'search_result_field' => false,
                'required'            => false,
                'weight'              => 1,
                'title'               => $fieldTitles,
                'description'         => [],
                'widget'              => [
                    'type'     => BridgeContentType::TEXT_WIDGET,
                    'settings' => [
                        'placeholder' => '',
                        'max_length'  => 255,
                    ],
                    'weight'   => 14,
                ],
                'type'                => BridgeContentType::TEXT_FIELD,
                'settings'            => [
                    'cardinality' => 1,
                ],
            ];
            // Create new field
            $this->write(
                'Création du nouveau champ <fg=cyan>reservation_description</fg=cyan> pour le type <fg=magenta>' . $type
                . '</fg=magenta>'
            );
            $this->writeResult(
                $bridge->contentTypeCreateOrUpdateField($type, 'reservation_description', $fieldOptions)
            );

            // Transfert des données
            $query = call_user_func(type_to_class($type) . '::query');
            foreach ($query->get() as $reservation) {
                $this->write('Mise-à-jour de la réservation <fg=green>' . $reservation->title . '</fg=green>');
                $this->writeResult(
                    null !== $contentBridge->contentUpdate(
                        $type,
                        [
                            'uuid'                    => $reservation->uuid,
                            'reservation_description' => Str::substr($reservation->body, 0, 254),
                        ]
                    )
                );
            }
            $this->write(
                'Suppression de l\'ancien champ <fg=cyan>body</fg=cyan> pour le type <fg=magenta>' . $type
                . '</fg=magenta>'
            );
            // Suppression du champ body
            try {
                $bridge->contentTypeDeleteField('node', $type, 'body');
            } catch (Exception $e) {
                $this->writeResult(false);
                $this->separatorLine('green');
                continue;
            }
            $this->writeResult(true);
            $this->separatorLine('green');
        }
    }
}
